<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión - Agricultura Inteligente</title>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat:wght@700;800&family=Poppins:wght@400;500;600&display=swap"
        rel="stylesheet">

    <!-- Boxicons for icons -->
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>

    <style>
        :root {
            --cafe-fondo: #3B2A1E;
            --verde-boton: #2D4636;
            --texto-claro: #F5F5F5;
            --blanco: #FFFFFF;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body,
        html {
            height: 100%;
            margin: 0;
            font-family: 'Poppins', sans-serif;
            background-color: var(--cafe-fondo);
            /* color: var(--texto-claro); */
            overflow: hidden;
        }

        /* Contenedor Principal */
        .main-container {
            width: 100%;
            height: 100vh;
            display: flex;
            position: relative;
            background-color: var(--cafe-fondo);
            overflow: hidden;
        }

        /* =====================
           LADO IZQUIERDO: Formulario
        ===================== */
        .content-side {
            width: 45%;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 40px 60px;
            z-index: 2;
            flex-shrink: 0;
        }

        .login-form-wrapper {
            width: 100%;
            max-width: 380px;
        }

        .login-title {
            font-family: 'Montserrat', sans-serif;
            font-size: 2rem;
            font-weight: 800;
            margin-bottom: 2.5rem;
            text-transform: uppercase;
            letter-spacing: 2px;
            color: #EFE6DD;
            text-align: center;
        }

        .field-group {
            position: relative;
            margin-bottom: 1.4rem;
        }

        .field-icon {
            position: absolute;
            left: 16px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 1.3rem;
            color: #5C6B3C;
            pointer-events: none;
        }

        .field-input {
            width: 100%;
            padding: 14px 14px 14px 48px;
            background-color: #EFE6DD;
            border: 1px solid rgba(255, 255, 255, 0.12);
            border-radius: 10px;
            color: #3B2A1E;
            font-family: 'Poppins', sans-serif;
            font-size: 1rem;
            outline: none;
            transition: border-color 0.3s, background-color 0.3s;
        }

        /* .field-input::placeholder {
            color: rgba(255, 255, 255, 0.35);
        } */

        /* .field-input:focus {
            border-color: rgba(255, 255, 255, 0.35);
            background-color: rgba(255, 255, 255, 0.13);
        } */

        .toggle-password {
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: rgba(255, 255, 255, 0.4);
            font-size: 1.2rem;
            transition: color 0.2s;
        }

        .toggle-password:hover {
            color: rgba(255, 255, 255, 0.7);
        }

        .volver-btn {
            width: 50%;
            padding: 10px;
            background-color: rgba(255, 255, 255, 0.15);
            color: #EFE6DD;
            border: none;
            border-radius: 10px;
            font-family: 'Montserrat', sans-serif;
            font-weight: 700;
            font-size: 1rem;
            cursor: pointer;
            letter-spacing: 0.5px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.35);
            transition: transform 0.25s, box-shadow 0.25s, filter 0.25s;
        }

        .login-btn {
            width: 100%;
            padding: 14px;
            background-color: #3c6b4c;
            color: #EFE6DD;
            border: none;
            border-radius: 10px;
            font-family: 'Montserrat', sans-serif;
            font-weight: 700;
            font-size: 1rem;
            cursor: pointer;
            margin-top: 0.8rem;
            letter-spacing: 0.5px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.35);
            transition: transform 0.25s, box-shadow 0.25s, filter 0.25s;
        }

        .login-btn:hover {
            transform: translateY(-2px);
            filter: brightness(1.15);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.45);
        }

        .forgot-link {
            display: block;
            text-align: center;
            margin-top: 1.4rem;
            color: rgba(255, 255, 255, 0.45);
            text-decoration: underline;
            font-size: 0.88rem;
            transition: color 0.2s;
        }

        .forgot-link:hover {
            color: rgba(255, 255, 255, 0.75);
        }

        .err-msg {
            background: rgba(220, 53, 69, 0.15);
            color: #ff8c94;
            padding: 12px;
            border-radius: 10px;
            margin-bottom: 1.5rem;
            text-align: center;
            border: 1px solid rgba(220, 53, 69, 0.3);
            font-size: 0.92rem;
        }

        /* =====================
           LADO DERECHO: Imagen PNG con forma orgánica
        ===================== */
        .image-side {
            flex: 1;
            height: 100%;
            position: relative;
            display: flex;
            justify-content: flex-end;
            align-items: center;
            overflow: hidden;
        }

        /* La imagen PNG ya tiene la forma redondeada/orgánica incorporada */
        .image-side img.cafe-img {
            position: absolute;
            right: -60px;
            /* Sobresale por la derecha para llenar el borde */
            top: 50%;
            transform: translateY(-50%);
            height: 120vh;
            /* Más grande para cubrir más ancho de pantalla */
            width: auto;
            max-width: none;
            object-fit: contain;
            filter: drop-shadow(-20px 0px 35px rgba(0, 0, 0, 0.7));
            z-index: 5;
        }

        /* =====================
           RESPONSIVO
        ===================== */
        @media (max-width: 900px) {
            .image-side {
                display: none;
            }

            .content-side {
                width: 100%;
                padding: 40px 30px;
            }

            body,
            html {
                overflow-y: auto;
            }
        }

        @media (max-width: 1200px) {
            .content-side {
                padding: 40px 40px;
            }

            .image-side img.cafe-img {
                height: 115vh;
                right: -40px;
            }
        }
    </style>
</head>

<body>

    <div class="main-container">
        <!-- Panel Izquierdo: Formulario -->
        <div class="content-side">
            <div class="login-form-wrapper">
                <h2 class="login-title">INICIAR SESIÓN</h2>

                <?php if (isset($error) && !empty($error)): ?>
                    <div class="err-msg">
                        <i class='bx bx-error-circle'></i> <?= htmlspecialchars($error) ?>
                    </div>
                <?php endif; ?>

                <form method="POST" action="login">
                    <div class="field-group">
                        <img src="/images/usuario.png" alt="Granos de café" class="field-icon">
                        <!-- <i class='bx bx-user field-icon'></i> -->
                        <input type="text" id="username" name="username" class="field-input"
                            placeholder="Usuario o e-mail" required>
                    </div>

                    <div class="field-group">
                        <img src="/images/candado.png" alt="Granos de café" class="field-icon">
                        <!-- <i class='bx bx-lock-alt field-icon'></i> -->
                        <input type="password" id="password" name="password" class="field-input"
                            placeholder="Contraseña" required>
                        <img src="/images/ojo.png" alt="Granos de café" class="toggle-password">
                        <!-- <i class='bx bx-show toggle-password' id="toggle-eye"></i> -->
                    </div>

                    <button type="submit" class="login-btn">Iniciar sesión</button>

                    <a href="#" class="forgot-link">¿Olvidaste tu usuario?</a>
                </form>
                <a href="/" class="volver-btn">Inicio</a>
            </div>
        </div>

        <!-- Panel Derecho: Imagen PNG orgánica superpuesta -->
        <div class="image-side">
            <img src="/images/cafelogin.png" alt="Granos de café" class="cafe-img">
        </div>
    </div>

    <script>
        const toggleEye = document.getElementById('toggle-eye');
        const passwordInput = document.getElementById('password');

        if (toggleEye) {
            toggleEye.addEventListener('click', () => {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                toggleEye.classList.toggle('bx-show');
                toggleEye.classList.toggle('bx-hide');
            });
        }
    </script>

</body>

</html>