<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agricultura Inteligente - Café</title>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@800&family=Poppins:wght@400;600&display=swap"
        rel="stylesheet">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html,
        body {
            width: 100%;
            height: 100%;
            font-family: 'Poppins', sans-serif;
            overflow: hidden;
        }

        /* Fondo: la imagen ocupa toda la pantalla */
        .page-wrapper {
            width: 100%;
            height: 100vh;
            background: url('../images/pag_inicio_cafe.webp') center center / cover no-repeat;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: flex-end;
            /* contenido pegado a la derecha */
        }

        /* Panel de texto flotando sobre la zona oscura derecha */
        .content-panel {
            width: 48%;
            padding: 0 6% 0 4%;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            position: relative;
            z-index: 10;
        }

        h1 {
            font-family: 'Montserrat', sans-serif;
            font-size: 3.2rem;
            font-weight: 800;
            line-height: 1.05;
            color: #FFFFFF;
            text-transform: uppercase;
            margin-bottom: 1.8rem;
            letter-spacing: -1px;
            text-shadow: 2px 4px 8px rgba(0, 0, 0, 0.5);
        }

        h1 span {
            color: #43694E;
        }

        p {
            font-size: 1.1rem;
            line-height: 1.65;
            color: rgba(255, 255, 255, 0.92);
            margin-bottom: 2.8rem;
            max-width: 480px;
        }

        .cta-btn {
            display: inline-block;
            background-color: #43694E;
            color: #FFFFFF;
            text-decoration: none;
            padding: 20px 42px;
            border-radius: 12px;
            font-family: 'Montserrat', sans-serif;
            font-weight: 800;
            font-size: 1.1rem;
            text-align: center;
            line-height: 1.3;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.5);
            transition: transform 0.3s ease, background-color 0.3s ease, box-shadow 0.3s ease;
            max-width: 100%;
            box-sizing: border-box;
        }

        .cta-btn:hover {
            transform: translateY(-3px);
            background-color: #4e7a5b;
            box-shadow: 0 14px 36px rgba(0, 0, 0, 0.65);
        }

        /* Responsive */
        @media (max-width: 1024px) {
            h1 {
                font-size: 2.4rem;
            }

            .content-panel {
                width: 55%;
                padding: 0 4% 0 3%;
            }
        }

        @media (max-width: 768px) {
            .page-wrapper {
                background-position: center center;
                align-items: center;
                /* Centrar verticalmente */
                justify-content: center;
            }

            .content-panel {
                width: 90%;
                /* Un poco más estrecho para que respire por los lados */
                max-width: 450px;
                padding: 3rem 1.5rem;
                background: rgba(35, 21, 13, 0.85);
                backdrop-filter: blur(8px);
                border-radius: 20px;
                align-items: center;
                text-align: center;
            }

            h1 {
                font-size: 1.8rem;
                margin-bottom: 1.5rem;
            }

            p {
                font-size: 1rem;
                margin-bottom: 2.2rem;
            }

            .cta-btn {
                width: 100%;
                max-width: 280px;
                padding: 16px 20px;
                font-size: 1rem;
            }
        }

        /* Para pantallas muy pequeñas (320px) */
        @media (max-width: 400px) {
            h1 {
                font-size: 1.7rem;
            }

            p {
                font-size: 0.9rem;
                margin-bottom: 2rem;
            }

            .cta-btn {
                max-width: 100%;
                padding: 14px 20px;
            }
        }
    </style>
</head>

<body>

    <div class="page-wrapper">
        <div class="content-panel">
            <h1>AGRICULTURA<br>INTELIGENTE<br>PARA <span>CAFÉ</span> DE<br>ALTA CALIDAD</h1>

            <p>
                Cada grano excepcional nace de una tierra bien nutrida.
                Nuestra herramienta analiza tu suelo y te entrega recomendaciones
                claras y accionables para mejorar el rendimiento y la calidad de tu cultivo.
            </p>

            <a href="login" class="cta-btn">
                Analizador de suelos<br>para café
            </a>
        </div>
    </div>

</body>

</html>