<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Analizador de Suelos para Café</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat:wght@600;700;800&family=Poppins:wght@400;500;600&display=swap"
        rel="stylesheet">

    <style>
        :root {
            --crema: #EFE6DD;
            --cafe-oscuro: #3B2A1E;
            --verde-medio: #3E6B48;
            --verde-oliva: #5C6B3C;
            --crema-input: #EFE6DD;
            --texto-form: #3B2A1E;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            min-height: 100vh;
            background: url('/images/fondo_cafe.png') center center / cover fixed;
            padding: 30px 16px 50px;
        }

        body::before {
            content: '';
            position: fixed;
            inset: 0;
            background: rgba(30, 15, 5, 0.55);
            z-index: 0;
        }

        /* ══════════════════════════════
           TARJETA PRINCIPAL
        ══════════════════════════════ */
        .main-card {
            position: relative;
            z-index: 1;
            max-width: 600px;
            margin: 0 auto;
            background: var(--crema);
            border-radius: 18px;
            overflow: hidden;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.55);
        }

        /* ── Cabecera ── */
        .header-actions {
            display: flex;
            justify-content: flex-end;
            padding: 12px 20px 0;
        }

        .btn-logout {
            font-family: 'Poppins', sans-serif;
            font-size: 0.78rem;
            font-weight: 600;
            color: var(--cafe-oscuro);
            background: transparent;
            border: 1.5px solid rgba(59, 42, 30, 0.35);
            border-radius: 20px;
            padding: 5px 14px;
            text-decoration: none;
            transition: all 0.2s;
        }

        .btn-logout:hover {
            background: var(--cafe-oscuro);
            color: var(--crema);
        }

        .main-header {
            padding: 10px 28px 20px;
            text-align: center;
        }

        .main-header h1 {
            font-family: 'Montserrat', sans-serif;
            font-size: 1.4rem;
            font-weight: 800;
            color: var(--cafe-oscuro);
            margin-bottom: 4px;
        }

        .main-header p {
            font-size: 0.8rem;
            color: rgba(59, 42, 30, 0.6);
            font-weight: 500;
        }

        /* ══════════════════════════════
           BARRA DE TABS
        ══════════════════════════════ */
        .tabs-nav {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            background: var(--cafe-oscuro);
            border-bottom: 3px solid var(--cafe-oscuro);
        }

        .tab-btn {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 4px;
            padding: 12px 6px;
            background: transparent;
            border: none;
            cursor: pointer;
            font-family: 'Poppins', sans-serif;
            font-size: 0.68rem;
            font-weight: 600;
            color: rgba(239, 230, 221, 0.55);
            text-align: center;
            line-height: 1.2;
            transition: background 0.25s, color 0.25s;
            position: relative;
        }

        .tab-btn .tab-icon {
            font-size: 1.2rem;
            line-height: 1;
        }

        .tab-btn::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 10%;
            width: 80%;
            height: 3px;
            background: var(--verde-medio);
            border-radius: 3px 3px 0 0;
            transform: scaleX(0);
            transition: transform 0.25s;
        }

        .tab-btn.active {
            color: var(--crema);
            background: rgba(255, 255, 255, 0.07);
        }

        .tab-btn.active::after {
            transform: scaleX(1);
        }

        .tab-btn:hover:not(.active) {
            color: rgba(239, 230, 221, 0.85);
            background: rgba(255, 255, 255, 0.04);
        }

        /* Número de tab (badge) */
        .tab-num {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.15);
            font-size: 0.65rem;
            font-weight: 700;
            margin-bottom: 2px;
            transition: background 0.25s;
        }

        .tab-btn.active .tab-num {
            background: var(--verde-medio);
        }

        /* ══════════════════════════════
           PANELES DE CONTENIDO
        ══════════════════════════════ */
        .tab-panels {
            /* sin padding aquí, lo pone cada panel */
        }

        .tab-panel {
            display: none;
            padding: 20px 20px 4px;
            animation: fadeIn 0.3s ease;
        }

        .tab-panel.active {
            display: block;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(6px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* ── Card de sección (dentro de cada panel) ── */
        .section-card {
            background: #fff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(59, 42, 30, 0.10);
        }

        .section-header {
            background: var(--verde-medio);
            padding: 10px 16px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .section-header img {
            width: 20px;
            height: 20px;
            object-fit: contain;
        }

        .section-header h2 {
            font-family: 'Montserrat', sans-serif;
            font-size: 0.88rem;
            font-weight: 700;
            color: #fff;
            letter-spacing: 0.3px;
        }

        .section-body {
            padding: 16px;
        }

        /* ── Grids de campos ── */
        .fields-grid {
            display: grid;
            gap: 12px 14px;
        }

        .fields-grid.cols-3 {
            grid-template-columns: repeat(3, 1fr);
        }

        .fields-grid.cols-2 {
            grid-template-columns: repeat(2, 1fr);
        }

        .fields-grid.cols-1 {
            grid-template-columns: 1fr;
        }

        .two-col-sub {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px 16px;
        }

        .sub-section {
            margin-top: 14px;
        }

        .sub-section-title {
            font-size: 0.74rem;
            font-weight: 600;
            color: var(--cafe-oscuro);
            margin-bottom: 10px;
            padding-bottom: 4px;
            border-bottom: 1px solid rgba(59, 42, 30, 0.15);
        }

        /* ── Campo individual ── */
        .field-item {
            display: flex;
            flex-direction: column;
            gap: 4px;
        }

        .field-item label {
            font-size: 0.71rem;
            font-weight: 600;
            color: var(--cafe-oscuro);
            letter-spacing: 0.2px;
        }

        .field-item input,
        .field-item select {
            width: 100%;
            padding: 7px 10px;
            background: var(--crema-input);
            border: 1px solid rgba(59, 42, 30, 0.18);
            border-radius: 6px;
            font-family: 'Poppins', sans-serif;
            font-size: 0.84rem;
            color: var(--texto-form);
            outline: none;
            transition: border-color 0.2s, box-shadow 0.2s;
            -webkit-appearance: auto;
            appearance: auto;
        }

        .field-item input:focus,
        .field-item select:focus {
            border-color: var(--verde-medio);
            box-shadow: 0 0 0 2px rgba(62, 107, 72, 0.18);
        }

        .field-item select {
            cursor: pointer;
        }

        /* ══════════════════════════════
           NAVEGACIÓN ENTRE TABS (botones Anterior / Siguiente)
        ══════════════════════════════ */
        .tab-nav-btns {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 16px 20px 20px;
            gap: 10px;
        }

        .btn-nav {
            display: flex;
            align-items: center;
            gap: 6px;
            padding: 9px 20px;
            border: none;
            border-radius: 8px;
            font-family: 'Poppins', sans-serif;
            font-size: 0.82rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
        }

        .btn-prev {
            background: rgba(59, 42, 30, 0.1);
            color: var(--cafe-oscuro);
        }

        .btn-prev:hover {
            background: rgba(59, 42, 30, 0.18);
        }

        .btn-next {
            background: var(--verde-medio);
            color: #fff;
            margin-left: auto;
        }

        .btn-next:hover {
            filter: brightness(1.1);
            transform: translateY(-1px);
        }

        /* ── Indicador de paso ── */
        .step-indicator {
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .step-dot {
            width: 7px;
            height: 7px;
            border-radius: 50%;
            background: rgba(59, 42, 30, 0.2);
            transition: background 0.25s, transform 0.25s;
        }

        .step-dot.active {
            background: var(--verde-medio);
            transform: scale(1.3);
        }

        /* ── Botón submit (última tab) ── */
        .btn-submit {
            width: 100%;
            padding: 13px;
            background: var(--cafe-oscuro);
            color: var(--crema);
            border: none;
            border-radius: 8px;
            font-family: 'Montserrat', sans-serif;
            font-weight: 700;
            font-size: 0.92rem;
            letter-spacing: 0.5px;
            cursor: pointer;
            transition: filter 0.25s, transform 0.2s, box-shadow 0.25s;
            box-shadow: 0 5px 18px rgba(0, 0, 0, 0.3);
        }

        .btn-submit:hover {
            filter: brightness(1.2);
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.4);
        }

        /* ══════════════════════════════
           HISTORIAL
        ══════════════════════════════ */
        .history-card {
            position: relative;
            z-index: 1;
            max-width: 600px;
            margin: 20px auto 0;
            background: var(--crema);
            border-radius: 18px;
            overflow: hidden;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.4);
        }

        .history-header {
            background: var(--verde-oliva);
            padding: 12px 20px;
        }

        .history-header h3 {
            font-family: 'Montserrat', sans-serif;
            font-size: 0.92rem;
            font-weight: 700;
            color: #fff;
        }

        .history-body {
            padding: 16px 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.82rem;
        }

        thead th {
            background: rgba(59, 42, 30, 0.08);
            color: var(--cafe-oscuro);
            font-weight: 700;
            padding: 8px 10px;
            text-align: left;
            border-bottom: 2px solid rgba(59, 42, 30, 0.15);
        }

        tbody td {
            padding: 8px 10px;
            border-bottom: 1px solid rgba(59, 42, 30, 0.08);
            color: var(--cafe-oscuro);
        }

        tbody tr:last-child td {
            border-bottom: none;
        }

        tbody tr:hover td {
            background: rgba(62, 107, 72, 0.06);
        }

        .btn-pdf {
            display: inline-block;
            padding: 4px 12px;
            background: var(--verde-medio);
            color: #fff;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-decoration: none;
            transition: filter 0.2s;
        }

        .btn-pdf:hover {
            filter: brightness(1.15);
        }

        .empty-row td {
            text-align: center;
            color: rgba(59, 42, 30, 0.45);
            padding: 20px;
            font-style: italic;
        }

        /* ══════════════════════════════
           RESPONSIVO
        ══════════════════════════════ */
        @media (max-width: 520px) {
            .tab-btn {
                font-size: 0.6rem;
                padding: 10px 4px;
            }

            .fields-grid.cols-3 {
                grid-template-columns: repeat(2, 1fr);
            }

            .two-col-sub {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 380px) {

            .fields-grid.cols-3,
            .fields-grid.cols-2 {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>

<body>

    <!-- ═══════════════════════════════════════
         TARJETA PRINCIPAL
    ═══════════════════════════════════════ -->
    <div class="main-card">

        <div class="header-actions">
            <a href="logout" class="btn-logout">Cerrar sesión</a>
        </div>
        <div class="main-header">
            <h1>Analizador de Suelos para Café</h1>
            <p>Complete la información para generar la recomendación técnica</p>
        </div>

        <form method="POST" action="dashboard" id="main-form">

            <!-- ══ BARRA DE TABS ══ -->
            <div class="tabs-nav" role="tablist">
                <button type="button" class="tab-btn active" data-tab="1" role="tab" aria-selected="true">
                    <span class="tab-num">1</span>
                    Info. del Lote
                </button>
                <button type="button" class="tab-btn" data-tab="2" role="tab" aria-selected="false">
                    <span class="tab-num">2</span>
                    Info. del Cultivo
                </button>
                <button type="button" class="tab-btn" data-tab="3" role="tab" aria-selected="false">
                    <span class="tab-num">3</span>
                    Propiedades del Suelo
                </button>
                <button type="button" class="tab-btn" data-tab="4" role="tab" aria-selected="false">
                    <span class="tab-num">4</span>
                    Macro y Micro Nutrientes
                </button>
            </div>

            <!-- ══ PANELES ══ -->
            <div class="tab-panels">

                <!-- ── Panel 1: Información del Lote ── -->
                <div class="tab-panel active" id="panel-1" role="tabpanel">
                    <div class="section-card">
                        <div class="section-header">
                            <img src="/images/hoja_titulos.png" alt="">
                            <h2>Información del Lote</h2>
                        </div>
                        <div class="section-body">
                            <div class="fields-grid cols-3">
                                <div class="field-item">
                                    <label>Área Lote (Ha)</label>
                                    <input type="number" step="any" name="area_lote_ha" placeholder="1.5" required>
                                </div>
                                <div class="field-item">
                                    <label>Profundidad (cm)</label>
                                    <input type="number" step="any" name="profundidad_cm" placeholder="20">
                                </div>
                                <div class="field-item">
                                    <label>Densidad (g/cm³)</label>
                                    <input type="number" step="any" name="densidad_gcm3" placeholder="1.1">
                                </div>
                            </div>
                            <div class="fields-grid cols-2" style="margin-top:12px;">
                                <div class="field-item">
                                    <label>% Sombra</label>
                                    <input type="number" step="any" name="sombra_pct" placeholder="35">
                                </div>
                                <div class="field-item">
                                    <label>Distancia entre plantas (m)</label>
                                    <input type="number" step="any" name="dist_plantas_m" placeholder="1.21">
                                </div>
                                <div class="field-item">
                                    <label>Distancia entre surcos (m)</label>
                                    <input type="number" step="any" name="dist_surcos_m" placeholder="1.5">
                                </div>
                                <div class="field-item">
                                    <label>N° Total Árboles</label>
                                    <input type="number" name="num_arboles" placeholder="7500">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ── Panel 2: Información del Cultivo ── -->
                <div class="tab-panel" id="panel-2" role="tabpanel">
                    <div class="section-card">
                        <div class="section-header">
                            <img src="/images/hoja_titulos.png" alt="">
                            <h2>Información del Cultivo</h2>
                        </div>
                        <div class="section-body">
                            <div class="fields-grid cols-2">
                                <div class="field-item">
                                    <label>Etapa del Cultivo</label>
                                    <select name="etapa_cultivo">
                                        <option value="">Seleccionar...</option>
                                        <option value="Vegetativa">Vegetativa</option>
                                        <option value="Reproductiva">Reproductiva</option>
                                        <option value="Produccion">Producción</option>
                                        <option value="Cosecha">Cosecha</option>
                                        <option value="Post-Cosecha">Post-Cosecha</option>
                                    </select>
                                </div>
                                <div class="field-item">
                                    <label>Edad (años)</label>
                                    <input type="number" step="any" name="edad_anos" placeholder="4.5">
                                </div>
                                <div class="field-item">
                                    <label>Frecuencia Fertilización</label>
                                    <select name="frecuencia_fertilizacion">
                                        <option value="">Seleccionar...</option>
                                        <option value="Mensual">Mensual</option>
                                        <option value="Bimensual">Bimensual</option>
                                        <option value="Cada 3 meses">Cada 3 meses</option>
                                        <option value="Trimestral">Trimestral</option>
                                        <option value="Semestral">Semestral</option>
                                        <option value="Anual">Anual</option>
                                    </select>
                                </div>
                                <div class="field-item">
                                    <label>Producción Promedio (@/cps/ha/año)</label>
                                    <input type="number" step="any" name="produccion_promedio" placeholder="0">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ── Panel 3: Propiedades del Suelo ── -->
                <div class="tab-panel" id="panel-3" role="tabpanel">
                    <div class="section-card">
                        <div class="section-header">
                            <img src="/images/hoja_titulos.png" alt="">
                            <h2>Propiedades del Suelo</h2>
                        </div>
                        <div class="section-body">
                            <div class="two-col-sub">
                                <!-- Izquierda: CIC y Bases -->
                                <div>
                                    <p class="sub-section-title">Capacidad de Intercambio y Bases (cmol(+)/kg)</p>
                                    <div class="fields-grid cols-1">
                                        <div class="field-item">
                                            <label>CIC</label>
                                            <input type="number" step="any" name="cic" placeholder="18.00">
                                        </div>
                                        <div class="field-item">
                                            <label>Aluminio (Al)</label>
                                            <input type="number" step="any" name="al" placeholder="0.30">
                                        </div>
                                        <div class="field-item">
                                            <label>Calcio (Ca)</label>
                                            <input type="number" step="any" name="ca" placeholder="2.50">
                                        </div>
                                        <div class="field-item">
                                            <label>Magnesio (Mg)</label>
                                            <input type="number" step="any" name="mg" placeholder="0.80">
                                        </div>
                                        <div class="field-item">
                                            <label>Potasio (K)</label>
                                            <input type="number" step="any" name="k" placeholder="0.30">
                                        </div>
                                        <div class="field-item">
                                            <label>Sodio (Na)</label>
                                            <input type="number" step="any" name="na" placeholder="0.10">
                                        </div>
                                    </div>
                                </div>
                                <!-- Derecha: Físicas y Químicas -->
                                <div>
                                    <p class="sub-section-title">Propiedades Físicas y Químicas</p>
                                    <div class="fields-grid cols-1">
                                        <div class="field-item">
                                            <label>pH (1:1)</label>
                                            <input type="number" step="any" name="ph" placeholder="5.20">
                                        </div>
                                        <div class="field-item">
                                            <label>C.E. (dS/m)</label>
                                            <input type="number" step="any" name="ce" placeholder="0.15">
                                        </div>
                                        <div class="field-item">
                                            <label>M. Orgánica (%)</label>
                                            <input type="number" step="any" name="mo" placeholder="10.00">
                                        </div>
                                        <div class="field-item">
                                            <label>Nitrógeno Total (%)</label>
                                            <input type="number" step="any" name="nitro_total" placeholder="0.40">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ── Panel 4: Macro y Micro Nutrientes ── -->
                <div class="tab-panel" id="panel-4" role="tabpanel">
                    <div class="section-card">
                        <div class="section-header">
                            <img src="/images/hoja_titulos.png" alt="">
                            <h2>Macro y Micro Nutrientes (ppm o mg/kg)</h2>
                        </div>
                        <div class="section-body">
                            <div class="two-col-sub">
                                <div class="fields-grid cols-1">
                                    <div class="field-item">
                                        <label>Fósforo (P)</label>
                                        <input type="number" step="any" name="p" placeholder="15.00">
                                    </div>
                                    <div class="field-item">
                                        <label>Azufre (S)</label>
                                        <input type="number" step="any" name="s" placeholder="8.00">
                                    </div>
                                    <div class="field-item">
                                        <label>Zinc (Zn)</label>
                                        <input type="number" step="any" name="zn" placeholder="2.00">
                                    </div>
                                    <div class="field-item">
                                        <label>Cobre (Cu)</label>
                                        <input type="number" step="any" name="cu" placeholder="2.00">
                                    </div>
                                </div>
                                <div class="fields-grid cols-1">
                                    <div class="field-item">
                                        <label>Boro (B)</label>
                                        <input type="number" step="any" name="b" placeholder="0.30">
                                    </div>
                                    <div class="field-item">
                                        <label>Hierro (Fe)</label>
                                        <input type="number" step="any" name="fe" placeholder="40.00">
                                    </div>
                                    <div class="field-item">
                                        <label>Manganeso (Mn)</label>
                                        <input type="number" step="any" name="mn" placeholder="8.00">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div><!-- /tab-panels -->

            <!-- ══ BOTONES DE NAVEGACIÓN ══ -->
            <div class="tab-nav-btns">
                <!-- Anterior (oculto en tab 1) -->
                <button type="button" class="btn-nav btn-prev" id="btn-prev" style="visibility:hidden;">
                    ← Anterior
                </button>

                <!-- Indicador de pasos -->
                <div class="step-indicator" id="step-indicator">
                    <span class="step-dot active" data-step="1"></span>
                    <span class="step-dot" data-step="2"></span>
                    <span class="step-dot" data-step="3"></span>
                    <span class="step-dot" data-step="4"></span>
                </div>

                <!-- Siguiente / Generar -->
                <button type="button" class="btn-nav btn-next" id="btn-next">
                    Siguiente →
                </button>
                <button type="submit" class="btn-submit" id="btn-submit" style="display:none;">
                    Generar Diagnóstico Completo
                </button>
            </div>

        </form>
    </div><!-- /main-card -->


    <!-- ═══════════════════════════════════════
         HISTORIAL DE DIAGNÓSTICOS
    ═══════════════════════════════════════ -->
    <div class="history-card">
        <div class="history-header">
            <h3>Historial de Diagnósticos</h3>
        </div>
        <div class="history-body">
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Fecha</th>
                        <th>Área (Ha)</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($records)): ?>
                        <tr class="empty-row">
                            <td colspan="4">No hay registros aún.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($records as $rec): ?>
                            <tr>
                                <td><?= $rec['id'] ?></td>
                                <td><?= isset($rec['created_at']) ? $rec['created_at'] : 'N/A' ?></td>
                                <td><?= isset($rec['area_lote_ha']) ? htmlspecialchars($rec['area_lote_ha']) : (isset($rec['name']) ? htmlspecialchars($rec['name']) : 'N/D') ?>
                                </td>
                                <td>
                                    <a href="pdf/<?= $rec['id'] ?>" class="btn-pdf" target="_blank">PDF</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- ═══════════════════════════════════════
         JAVASCRIPT: Lógica de Tabs
    ═══════════════════════════════════════ -->
    <script>
        const TOTAL_TABS = 4;
        let currentTab = 1;

        const tabBtns = document.querySelectorAll('.tab-btn');
        const tabPanels = document.querySelectorAll('.tab-panel');
        const stepDots = document.querySelectorAll('.step-dot');
        const btnPrev = document.getElementById('btn-prev');
        const btnNext = document.getElementById('btn-next');
        const btnSubmit = document.getElementById('btn-submit');

        function goToTab(n) {
            // Desactivar todo
            tabBtns.forEach(b => { b.classList.remove('active'); b.setAttribute('aria-selected', 'false'); });
            tabPanels.forEach(p => p.classList.remove('active'));
            stepDots.forEach(d => d.classList.remove('active'));

            // Activar el tab n
            tabBtns[n - 1].classList.add('active');
            tabBtns[n - 1].setAttribute('aria-selected', 'true');
            document.getElementById('panel-' + n).classList.add('active');
            stepDots[n - 1].classList.add('active');

            currentTab = n;

            // Botón Anterior
            btnPrev.style.visibility = (n === 1) ? 'hidden' : 'visible';

            // Botón Siguiente / Generar
            if (n === TOTAL_TABS) {
                btnNext.style.display = 'none';
                btnSubmit.style.display = 'block';
            } else {
                btnNext.style.display = 'inline-flex';
                btnSubmit.style.display = 'none';
            }

            // Scroll suave al inicio de la tarjeta
            document.querySelector('.main-card').scrollIntoView({ behavior: 'smooth', block: 'start' });
        }

        // Click en tabs de la barra
        tabBtns.forEach(btn => {
            btn.addEventListener('click', () => goToTab(parseInt(btn.dataset.tab)));
        });

        // Botones Anterior / Siguiente
        btnPrev.addEventListener('click', () => { if (currentTab > 1) goToTab(currentTab - 1); });
        btnNext.addEventListener('click', () => { if (currentTab < TOTAL_TABS) goToTab(currentTab + 1); });

        // Inicializar
        goToTab(1);
    </script>

</body>

</html>