<?php

$db_file = __DIR__ . '/../database.json';

function get_db_data()
{
    global $db_file;
    if (!file_exists($db_file)) {
        return ['users' => [], 'records' => []];
    }
    $json = file_get_contents($db_file);
    return json_decode($json, true) ?? ['users' => [], 'records' => []];
}

function save_db_data($data)
{
    global $db_file;
    file_put_contents($db_file, json_encode($data, JSON_PRETTY_PRINT));
}

function verify_login($username, $password)
{
    $data = get_db_data();
    if (isset($data['users']) && is_array($data['users'])) {
        foreach ($data['users'] as $user) {
            // Comparación simple de texto plano como solicitado
            if ($user['username'] === $username && $user['password'] === $password) {
                return true;
            }
        }
    }
    return false;
}

function add_new_record($formData)
{
    $data = get_db_data();
    $newId = 1;

    // Asegurarse de que 'records' exista
    if (!isset($data['records'])) {
        $data['records'] = [];
    }

    if (!empty($data['records'])) {
        $lastRecord = end($data['records']);
        $newId = $lastRecord['id'] + 1;
    }

    // Agregar ID y fecha de creación
    $formData['id'] = $newId;
    $formData['created_at'] = date('Y-m-d H:i:s');

    $data['records'][] = $formData;

    save_db_data($data);
}

function get_all_records()
{
    $data = get_db_data();
    return isset($data['records']) ? $data['records'] : [];
}

function get_record_by_id($id)
{
    $data = get_db_data();
    if (isset($data['records'])) {
        foreach ($data['records'] as $record) {
            if ($record['id'] == $id) {
                return $record;
            }
        }
    }
    return null;
}
