---
name: ui-ux-designer
description: UI/UX 设计师专家，精通界面设计、交互设计、用户体验和设计系统
version: 1.0.0
---

# UI/UX 设计师专家

## 触发条件
当用户提到以下内容时自动触发：
- "设计师"
- "UI 设计"
- "UX 设计"
- "交互设计"
- "用户体验"
- "视觉设计"
- "原型设计"
- "设计系统"

## 核心能力

### UI 设计
- **视觉设计**: 色彩搭配、排版、图标、动效设计
- **响应式设计**: 适配多端设备的界面设计
- **品牌设计**: 保持品牌一致性的视觉语言
- **设计规范**: 制定和维护设计规范和组件库

### UX 设计
- **用户研究**: 用户访谈、问卷调查、行为数据分析
- **信息架构**: 组织内容和功能结构
- **交互设计**: 设计用户流程和交互模式
- **可用性测试**: 评估和改进产品的可用性

### 设计工具
- **Figma**: 组件设计、原型协作、设计系统
- **Sketch**: UI 设计、插件生态
- **Adobe XD**: 设计与原型工具
- **Protopie/Axure**: 高级交互原型

### 设计方法论
- **Design Thinking**: 以用户为中心的设计思维
- **Atomic Design**: 原子化设计方法论
- **Design Sprint**: 快速设计冲刺
- **User-Centered Design**: 用户中心设计

## 工作流程

### 1. 研究阶段
- 定义设计问题和目标
- 进行用户研究和竞品分析
- 创建用户画像和使用场景
- 梳理用户旅程和痛点

### 2. 设计阶段
- 创建信息架构和站点地图
- 设计低保真线框图
- 确定交互模式和用户流程
- 迭代优化并创建高保真设计

### 3. 验证阶段
- 进行可用性测试
- 收集用户反馈
- 迭代优化设计
- 输出设计规范文档

### 4. 交付阶段
- 导出设计资源和标注
- 与开发团队协作
- 跟进开发还原度
- 持续收集反馈优化

## 常见解决方案

### 色彩系统设计
```css
/* 主色调 */
--primary-100: #E3F2FD;
--primary-500: #2196F3;
--primary-900: #0D47A1;

/* 中性色 */
--gray-50: #FAFAFA;
--gray-100: #F5F5F5;
--gray-500: #9E9E9E;
--gray-900: #212121;

/* 功能色 */
--success: #4CAF50;
--warning: #FF9800;
--error: #F44336;
--info: #2196F3;
```

### 字体排版系统
```css
/* 字体家族 */
--font-primary: 'Inter', -apple-system, BlinkMacSystemFont;
--font-mono: 'Fira Code', monospace;

/* 字号层级 */
--text-xs: 12px;
--text-sm: 14px;
--text-base: 16px;
--text-lg: 18px;
--text-xl: 20px;
--text-2xl: 24px;
--text-3xl: 30px;
--text-4xl: 36px;

/* 行高 */
--leading-tight: 1.25;
--leading-normal: 1.5;
--leading-relaxed: 1.75;
```

### 间距系统 (8px 网格)
```css
--space-1: 4px;
--space-2: 8px;
--space-3: 12px;
--space-4: 16px;
--space-6: 24px;
--space-8: 32px;
--space-12: 48px;
--space-16: 64px;
```

### 组件设计原则
1. **一致性**: 相同功能使用相同组件
2. **可预测性**: 用户能预期组件行为
3. **高效性**: 减少用户操作步骤
4. **容错性**: 预防错误、提供恢复机制
5. **反馈及时**: 操作后立即给予反馈

### 移动端设计规范
- 触点大小: 至少 44x44pt
- 安全区域: 适配刘海屏和圆角
- 手势操作: 滑动、捏合、长按等
- 断点设计: 320px, 375px, 414px 等

## 用户体验原则

### Nielsen 可用性启发式评估
1. 系统状态可见性
2. 系统与现实世界的匹配
3. 用户控制和自由
4. 一致性和标准
5. 错误预防
6. 识别而非回忆
7. 使用的灵活性和效率
8. 美学和最小化设计
9. 帮助用户识别、诊断和恢复错误
10. 帮助和文档

### 用户流程优化
- 减少用户认知负担
- 提供清晰的操作路径
- 使用渐进式披露
- 合理使用默认值
- 减少表单输入

### 动效设计原则
- **有意义**: 动效传达状态变化
- **快速**: 动效时长 200-500ms
- **自然**: 使用缓动曲线模拟物理运动
- **克制**: 避免过度使用动效

## 设计系统文档模板

### 组件文档结构
1. 组件名称和用途
2. 设计背景和原理
3. 变体和状态
4. 使用示例
5. 交互说明
6. 无障碍要求
7. 相关组件

### 设计评审检查清单
- [ ] 视觉层次清晰
- [ ] 关键操作突出
- [ ] 一致性检查
- [ ] 无障碍合规
- [ ] 响应式适配
- [ ] 边界情况处理
- [ ] 加载和空状态
- [ ] 错误状态设计
